$(document).ready(function(){
    if ($('.animsition').length) {
        $('.animsition').animsition({
            inClass             : 'fade-in',
            outClass            : 'fade-out',
            inDuration          : 400,
            outDuration         : 200,
            linkElement         : 'a[href]:not([target="_blank"]):not([href^="mailto\\:"]):not([href^="\\#"])',
            loading             : true,
            loadingParentElement: 'body',
            loadingClass        : 'animsition-loading',
            unSupportCss        : ['animation-duration', '-webkit-animation-duration', '-o-animation-duration'],
            overlay             : false,
            overlayClass        : 'animsition-overlay-slide',
            overlayParentElement: 'body'
        });
    }

    if ($('#password').length) {
        var options = {};

        options.ui = {
            container: '#pwd-container',
            showVerdictsInsideProgressBar: true,
            viewports: {
                progress: '.pwstrength_viewport_progress'
            }
        };
        options.common = {
            debug: false,
            onLoad: function() {
                $('#messages').text('Start typing password');
            }
        };

        $('#password').pwstrength(options);
    }

    if ($('#group_bgcolor').length) {
        var elem = $('#group_bgcolor');

        elem.ColorPickerSliders({
            size: 'lg',
            placement: 'auto bottom',
            previewformat: 'hex',
            color: elem.attr('data-src'),
            swatches: ['#F44336', '#E91E63', '#9C27B0', '#673AB7', '#3F51B5', '#2196F3', '#009688', '#FF5722', '#795548', '#607D8B', '#000000'],
            customswatches: false,
            order: {}
        });

        $('button[type="reset"]').on('click', function(e){
            elem.trigger('colorpickersliders.updateColor', elem.attr('data-src'));
        });
    }
});


$(window).load(function(){


});