<?php
namespace App;

class Auth
{
    public static function user(): ?array
    {
        if (isset($_SERVER['__auth_user'])) return $_SERVER['__auth_user'];
        $token = $_COOKIE['sess'] ?? '';
        if (!$token) return null;
        try {
            $pdo = Database::pdo();
            $stmt = $pdo->prepare('SELECT u.* FROM sessions s JOIN users u ON u.id = s.user_id WHERE s.session_token = :t AND s.expires_at > NOW() LIMIT 1');
            $stmt->execute([':t'=>$token]);
            $user = $stmt->fetch();
            $_SERVER['__auth_user'] = $user ?: null;
            return $user ?: null;
        } catch (\Throwable $e) { return null; }
    }

    public static function requireUser(): array
    {
        $u = self::user();
        if (!$u) {
            header('Location: /login');
            exit;
        }
        return $u;
    }

    public static function login(int $userId): void
    {
        $token = bin2hex(random_bytes(24));
        $ua = substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 250);
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $expires = date('Y-m-d H:i:s', time() + 86400*14);
        $pdo = Database::pdo();
        $pdo->prepare('INSERT INTO sessions (user_id, session_token, ip, ua, expires_at) VALUES (:u,:t,:ip,:ua,:e)')
            ->execute([':u'=>$userId, ':t'=>$token, ':ip'=>$ip, ':ua'=>$ua, ':e'=>$expires]);
        setcookie('sess', $token, time()+86400*14, '/', '', isset($_SERVER['HTTPS']), true);
    }

    public static function logout(): void
    {
        $token = $_COOKIE['sess'] ?? '';
        if ($token) {
            try {
                Database::pdo()->prepare('DELETE FROM sessions WHERE session_token = :t')->execute([':t'=>$token]);
            } catch (\Throwable $e) {}
        }
        setcookie('sess', '', time()-3600, '/');
    }

    public static function csrfToken(): string
    {
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
        return $_SESSION['csrf'];
    }

    public static function checkCsrf(string $token): bool
    {
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        return hash_equals($_SESSION['csrf'] ?? '', $token);
    }
}

