<?php
namespace App;

use App\Database;
use PDO;

class CacheStore
{
    public static function get(string $key)
    {
        $stmt = Database::pdo()->prepare('SELECT `value`, `expires_at` FROM cache_store WHERE `key` = :k LIMIT 1');
        $stmt->execute([':k'=>$key]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) return null;
        if (!empty($row['expires_at']) && strtotime($row['expires_at']) < time()) {
            Database::pdo()->prepare('DELETE FROM cache_store WHERE `key` = :k')->execute([':k'=>$key]);
            return null;
        }
        return $row['value'];
    }

    public static function set(string $key, string $value, int $ttlSec): void
    {
        $exp = date('Y-m-d H:i:s', time() + $ttlSec);
        $stmt = Database::pdo()->prepare('REPLACE INTO cache_store (`key`, `value`, `expires_at`) VALUES (:k, :v, :e)');
        $stmt->execute([':k'=>$key, ':v'=>$value, ':e'=>$exp]);
    }

    public static function remember(string $key, int $ttlSec, callable $cb)
    {
        $hit = self::get($key);
        if ($hit !== null) return $hit;
        $val = $cb();
        self::set($key, $val, $ttlSec);
        return $val;
    }
}

