<?php
namespace App\Controllers\Api;

use App\Auth;
use App\Database;

class ScreensApiController
{
    public function star(string $slug): void
    {
        header('Content-Type: application/json');
        $user = Auth::user();
        if (!$user) { http_response_code(401); echo json_encode(['error'=>'auth']); return; }
        $pdo = Database::pdo();
        $s = $pdo->prepare('SELECT id FROM screens WHERE slug = :s LIMIT 1');
        $s->execute([':s'=>$slug]);
        $id = (int)$s->fetchColumn();
        if (!$id) { http_response_code(404); echo json_encode(['error'=>'not_found']); return; }
        $check = $pdo->prepare('SELECT 1 FROM screen_stars WHERE user_id = :u AND screen_id = :sid');
        $check->execute([':u'=>(int)$user['id'], ':sid'=>$id]);
        $has = (bool)$check->fetchColumn();
        if ($has) {
            $pdo->prepare('DELETE FROM screen_stars WHERE user_id = :u AND screen_id = :sid')->execute([':u'=>(int)$user['id'], ':sid'=>$id]);
            echo json_encode(['starred'=>false]);
        } else {
            $pdo->prepare('INSERT IGNORE INTO screen_stars (user_id, screen_id) VALUES (:u,:sid)')->execute([':u'=>(int)$user['id'], ':sid'=>$id]);
            echo json_encode(['starred'=>true]);
        }
    }
}

