<?php
namespace App\Controllers\Api;

use App\Auth;
use App\Models\Coin;
use App\Models\Watchlist;

class WatchlistApiController
{
    public function toggle(): void
    {
        header('Content-Type: application/json');
        $user = Auth::user();
        if (!$user) { http_response_code(401); echo json_encode(['error'=>'auth']); return; }
        $slug = $_POST['slug'] ?? '';
        $watchlistSlug = $_POST['watchlist_slug'] ?? '';
        if (!$slug) { http_response_code(400); echo json_encode(['error'=>'bad_request']); return; }
        $coinId = Coin::idBySlug($slug);
        if (!$coinId) { http_response_code(404); echo json_encode(['error'=>'not_found']); return; }
        // choose target watchlist
        if ($watchlistSlug) {
            $pdo = \App\Database::pdo();
            $st = $pdo->prepare('SELECT id FROM watchlists WHERE user_id = :u AND slug = :s LIMIT 1');
            $st->execute([':u'=>(int)$user['id'], ':s'=>$watchlistSlug]);
            $wlId = (int)$st->fetchColumn();
            if (!$wlId) $wlId = Watchlist::defaultIdForUser((int)$user['id']);
        } else {
            $wlId = Watchlist::defaultIdForUser((int)$user['id']);
        }
        $in = Watchlist::isIn($wlId, $coinId);
        if ($in) {
            Watchlist::remove($wlId, $coinId);
        } else {
            Watchlist::add($wlId, $coinId);
        }
        echo json_encode(['in_watchlist'=>!$in]);
    }

    public function membership(): void
    {
        header('Content-Type: application/json');
        $user = Auth::user();
        if (!$user) { echo json_encode(['slugs'=>[]]); return; }
        $slugs = isset($_GET['slugs']) ? array_values(array_filter(explode(',', (string)$_GET['slugs']))) : [];
        // optional watchlist
        $watchlistSlug = $_GET['watchlist_slug'] ?? '';
        $wlId = null;
        if ($watchlistSlug) {
            $pdo = \App\Database::pdo();
            $st = $pdo->prepare('SELECT id FROM watchlists WHERE user_id = :u AND slug = :s LIMIT 1');
            $st->execute([':u'=>(int)$user['id'], ':s'=>$watchlistSlug]);
            $wlId = (int)$st->fetchColumn();
        }
        if (!$wlId) $wlId = Watchlist::defaultIdForUser((int)$user['id']);
        $have = [];
        if (!empty($slugs)) {
            $pdo = \App\Database::pdo();
            $in = implode(',', array_fill(0, count($slugs), '?'));
            $sql = "SELECT c.slug FROM watchlist_items wi JOIN coins c ON c.id = wi.coin_id WHERE wi.watchlist_id = ? AND c.slug IN ($in)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute(array_merge([$wlId], $slugs));
            $have = array_map(fn($r)=>$r['slug'], $stmt->fetchAll());
        }
        echo json_encode(['slugs'=>$have]);
    }

    public function listUserWatchlists(): void
    {
        header('Content-Type: application/json');
        $user = Auth::user();
        if (!$user) { echo json_encode(['lists'=>[]]); return; }
        $st = \App\Database::pdo()->prepare('SELECT id, name, slug, visibility, is_default FROM watchlists WHERE user_id = :u ORDER BY is_default DESC, id DESC');
        $st->execute([':u'=>(int)$user['id']]);
        echo json_encode(['lists'=>$st->fetchAll()]);
    }
}
