<?php
namespace App\Controllers;

use App\View;
use App\Models\Category;
use App\SEO;
use App\Snapshot;

class CategoriesController
{
    public function index(): void
    {
        $meta = \App\SEO::listCategoriesMeta();
        $html = View::render('categories/list', [
            'title' => $meta['title'] ?? 'Categories — BlocFolio',
            'meta' => $meta,
        ]);
        if (\App\Config::get('app.env') === 'prod' && (\App\Config::get('seo.snapshots.enable_lists', true))) {
            $ttl = (int)\App\Config::get('seo.snapshots.ttl.categories', 21600);
            \App\Snapshot::write('/categories', $html, $ttl);
        }
        echo $html;
    }

    public function show(string $slug): void
    {
        $cat = Category::findBySlug($slug);
        if (!$cat) {
            http_response_code(404);
            echo View::render('errors/404', ['title' => 'Category Not Found']);
            return;
        }
        $meta = SEO::categoryMeta($cat);
        $html = View::render('categories/show', [
            'title' => $meta['title'] ?? (($cat['name'] ?? 'Category') . ' — BlocFolio'),
            'meta' => $meta,
            'category' => $cat,
        ]);
        if (\App\Config::get('app.env') === 'prod') {
            Snapshot::write('/categories/' . ($cat['slug'] ?? ''), $html, 12*3600);
        }
        echo $html;
    }
}
