<?php
namespace App\Controllers;

use App\View;
use App\Models\Exchange;
use App\SEO;
use App\Snapshot;

class ExchangesController
{
    public function index(): void
    {
        $meta = \App\SEO::listExchangesMeta();
        $html = View::render('exchanges/list', [
            'title' => $meta['title'] ?? 'Exchanges — BlocFolio',
            'meta' => $meta,
        ]);
        if (\App\Config::get('app.env') === 'prod' && (\App\Config::get('seo.snapshots.enable_lists', true))) {
            $ttl = (int)\App\Config::get('seo.snapshots.ttl.exchanges', 21600);
            \App\Snapshot::write('/exchanges', $html, $ttl);
        }
        echo $html;
    }

    public function show(string $slug): void
    {
        $ex = Exchange::findBySlug($slug);
        if (!$ex) {
            http_response_code(404);
            echo View::render('errors/404', ['title' => 'Exchange Not Found']);
            return;
        }
        $meta = SEO::exchangeMeta($ex);
        $html = View::render('exchanges/show', [
            'title' => $meta['title'] ?? (($ex['name'] ?? 'Exchange') . ' — BlocFolio'),
            'meta' => $meta,
            'exchange' => $ex,
        ]);
        if (\App\Config::get('app.env') === 'prod') {
            Snapshot::write('/exchanges/' . ($ex['slug'] ?? ''), $html, 12*3600);
        }
        echo $html;
    }
}
