<?php
namespace App\Controllers;

use App\View;

class ToolsController
{
    public function index(): void
    {
        echo \App\View::render('tools/index', ['title'=>'Tools — BlocFolio']);
    }
    public function pl(): void
    {
        $entry = (float)($_GET['entry'] ?? 0);
        $exit = (float)($_GET['exit'] ?? 0);
        $qty = (float)($_GET['qty'] ?? 0);
        $fees = (float)($_GET['fees'] ?? 0);
        $pnl = ($exit - $entry) * $qty - $fees;
        $roi = $entry > 0 ? ($pnl / ($entry * $qty)) * 100 : null;
        $breakeven = $qty > 0 ? ($fees / $qty) + $entry : null;
        echo View::render('tools/pl', [
            'title' => 'P/L Calculator — BlocFolio',
            'pnl' => $pnl, 'roi' => $roi, 'breakeven' => $breakeven,
            'entry' => $entry, 'exit' => $exit, 'qty' => $qty, 'fees' => $fees,
        ]);
    }

    public function cagr(): void
    {
        $initial = (float)($_GET['initial'] ?? 0);
        $final = (float)($_GET['final'] ?? 0);
        $years = max(0.0001, (float)($_GET['years'] ?? 1));
        $cagr = ($initial > 0 && $final > 0) ? (pow($final/$initial, 1/$years) - 1) * 100 : null;
        echo View::render('tools/cagr', [
            'title'=>'CAGR Calculator — BlocFolio','initial'=>$initial,'final'=>$final,'years'=>$years,'cagr'=>$cagr,
        ]);
    }

    public function dca(): void
    {
        $amount = (float)($_GET['amount'] ?? 100);
        $intervals = (int)($_GET['intervals'] ?? 12);
        $price = (float)($_GET['price'] ?? 100);
        $growth = (float)($_GET['growth'] ?? 0); // % per interval
        $totalInvested = $amount * $intervals;
        $units = 0; $curPrice = $price;
        for ($i=0;$i<$intervals;$i++) { $units += $amount / max(0.0000001,$curPrice); $curPrice *= (1+$growth/100); }
        $finalVal = $units * $curPrice;
        echo View::render('tools/dca', [
            'title'=>'DCA Calculator — BlocFolio','amount'=>$amount,'intervals'=>$intervals,'price'=>$price,'growth'=>$growth,
            'invested'=>$totalInvested,'units'=>$units,'finalVal'=>$finalVal,
        ]);
    }

    public function position(): void
    {
        $equity = (float)($_GET['equity'] ?? 10000);
        $riskPct = (float)($_GET['risk'] ?? 1);
        $stopDist = max(0.000001, (float)($_GET['stop'] ?? 5));
        $size = ($equity * ($riskPct/100)) / $stopDist;
        echo View::render('tools/position', [
            'title'=>'Position Sizing — BlocFolio','equity'=>$equity,'risk'=>$riskPct,'stop'=>$stopDist,'size'=>$size,
        ]);
    }
}
