<?php
namespace App\Models;

use App\Database;
use App\Config;
use PDO;

class Category
{
    public static function dataTable(int $start, int $length, string $sort, string $dir, ?string $search): array
    {
        $pdo = Database::pdo();
        $sortMap = [
            'name' => 'c.name',
            'market_cap' => 'c.market_cap',
            'volume_24h' => 'c.volume_24h',
            'num_coins' => 'c.num_coins',
        ];
        $sortCol = $sortMap[$sort] ?? 'c.market_cap';
        $dir = strtoupper($dir) === 'DESC' ? 'DESC' : 'ASC';
        $baseWhere = '1=1';
        $total = (int)$pdo->query('SELECT COUNT(*) FROM categories c WHERE ' . $baseWhere)->fetchColumn();
        $params = [];
        $where = $baseWhere;
        if ($search) { $where .= ' AND c.name LIKE :q'; $params[':q'] = '%' . $search . '%'; }
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM categories c WHERE ' . $where);
        $stmt->execute($params);
        $filtered = (int)$stmt->fetchColumn();
        $sql = "SELECT c.name, c.slug, c.market_cap, c.volume_24h, c.num_coins
                FROM categories c
                WHERE $where
                ORDER BY $sortCol $dir
                LIMIT :length OFFSET :start";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $k=>$v) $stmt->bindValue($k,$v);
        $stmt->bindValue(':length',$length,PDO::PARAM_INT);
        $stmt->bindValue(':start',$start,PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll();
        return [$rows, $total, $filtered];
    }

    public static function findBySlug(string $slug): ?array
    {
        $pdo = Database::pdo();
        $stmt = $pdo->prepare('SELECT * FROM categories WHERE slug = :slug LIMIT 1');
        $stmt->execute([':slug'=>$slug]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function coinsForCategory(int $categoryId, int $start, int $length, string $sort, string $dir, ?string $search): array
    {
        $pdo = Database::pdo();
        $currency = Config::get('app.currency_default','USD');
        $sortMap = [
            'rank' => 'coins.rank',
            'name' => 'coins.name',
            'market_cap' => 'ms.market_cap',
            'price' => 'ms.price',
            'change_24h' => 'ms.change_24h',
            'volume_24h' => 'ms.volume_24h',
        ];
        $sortCol = $sortMap[$sort] ?? 'coins.rank';
        $dir = strtoupper($dir) === 'DESC' ? 'DESC' : 'ASC';
        $params = [':cat'=>$categoryId];
        $where = 'cc.category_id = :cat';
        if ($search) { $where .= ' AND (coins.name LIKE :q OR coins.symbol LIKE :q)'; $params[':q'] = '%' . $search . '%'; }

        $stmt = $pdo->prepare('SELECT COUNT(*) FROM coin_categories cc JOIN coins ON coins.id = cc.coin_id WHERE ' . $where);
        $stmt->execute($params);
        $filtered = (int)$stmt->fetchColumn();
        $totalStmt = $pdo->prepare('SELECT COUNT(*) FROM coin_categories WHERE category_id = :cat');
        $totalStmt->execute([':cat'=>$categoryId]);
        $total = (int)$totalStmt->fetchColumn();

        $sql = "
            SELECT coins.rank, coins.name, coins.slug, coins.symbol,
                   ms.price, ms.market_cap, ms.volume_24h, ms.change_24h
            FROM coin_categories cc
            JOIN coins ON coins.id = cc.coin_id
            LEFT JOIN coin_market_snapshots ms
              ON ms.id = (
                  SELECT id FROM coin_market_snapshots
                  WHERE currency = :currency AND coin_id = coins.id
                  ORDER BY timestamp DESC LIMIT 1
              )
            WHERE $where
            ORDER BY $sortCol $dir
            LIMIT :length OFFSET :start
        ";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $k=>$v) $stmt->bindValue($k,$v);
        $stmt->bindValue(':currency', strtolower($currency));
        $stmt->bindValue(':length',$length,PDO::PARAM_INT);
        $stmt->bindValue(':start',$start,PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll();
        return [$rows, $total, $filtered];
    }
}

