<?php
namespace App;

class SEO
{
    public static function coinMeta(array $coin, string $currency = 'USD'): array
    {
        $name = $coin['name'] ?? '';
        $symbol = strtoupper($coin['symbol'] ?? '');
        $price = $coin['price'] !== null ? number_format((float)$coin['price'], 4) : '—';
        $titleTpl = Config::get('seo.coin.title', '{name} ({symbol}) Price, Chart, Market Cap & Stats — BlocFolio');
        $descTpl = Config::get('seo.coin.description', 'Live {name} price in {currency}, market cap, 24h volume, 1h/24h/7d/30d change, ATH/ATL, supply & exchanges. Charts + analysis. Powered by CoinGecko.');
        $repl = [
            '{name}' => $name,
            '{symbol}' => $symbol,
            '{currency}' => strtoupper($currency),
            '{price}' => (string)$price,
        ];
        $title = strtr($titleTpl, $repl);
        $desc = strtr($descTpl, $repl);
        $img = $coin['image_small'] ?? $coin['image_thumb'] ?? null;
        $slug = $coin['slug'] ?? '';
        $url = rtrim(Config::get('app.base_url',''),'/') . '/coins/' . $slug;

        $jsonLd = [
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => $title,
            'description' => $desc,
            'url' => $url,
            'isPartOf' => [
                '@type' => 'WebSite',
                'name' => 'BlocFolio',
                'url' => rtrim(Config::get('app.base_url',''),'/') ?: null,
            ],
        ];

        return [
            'title' => $title,
            'description' => $desc,
            'og' => [
                'title' => $title,
                'description' => $desc,
                'image' => $img,
                'url' => $url,
            ],
            'canonical' => $url,
            'json_ld' => $jsonLd,
        ];
    }

    public static function exchangeMeta(array $ex): array
    {
        $name = $ex['name'] ?? '';
        $title = "$name Exchange — Volume, Markets & Fees — BlocFolio";
        $desc = "$name exchange overview: 24h volume, markets and quick facts.";
        $slug = $ex['slug'] ?? '';
        $url = rtrim(Config::get('app.base_url',''),'/') . '/exchanges/' . $slug;
        $img = $ex['logo'] ?? null;
        return [
            'title' => $title,
            'description' => $desc,
            'og' => ['title'=>$title,'description'=>$desc,'image'=>$img,'url'=>$url],
            'canonical' => $url,
            'json_ld' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => $title,
                'description' => $desc,
                'url' => $url,
            ],
        ];
    }

    public static function categoryMeta(array $cat): array
    {
        $name = $cat['name'] ?? '';
        $title = "$name Category — Coins, Market Cap & Volume — BlocFolio";
        $desc = "$name category coins with market cap, volume and performance.";
        $slug = $cat['slug'] ?? '';
        $url = rtrim(Config::get('app.base_url',''),'/') . '/categories/' . $slug;
        return [
            'title' => $title,
            'description' => $desc,
            'og' => ['title'=>$title,'description'=>$desc,'url'=>$url],
            'canonical' => $url,
            'json_ld' => [
                '@context' => 'https://schema.org',
                '@type' => 'CollectionPage',
                'name' => $title,
                'description' => $desc,
                'url' => $url,
            ],
        ];
    }

    public static function listCoinsMeta(): array
    {
        $title = Config::get('seo.lists.coins.title', 'Top Crypto Coins by Market Cap — BlocFolio');
        $desc = Config::get('seo.lists.coins.description', 'Live market caps, prices, and 24h change for top cryptocurrencies.');
        $url = rtrim(Config::get('app.base_url',''),'/') . '/coins';
        $jsonLd = null;
        if (Config::get('seo.lists.coins.jsonld', true)) {
            $jsonLd = [
                '@context' => 'https://schema.org',
                '@type' => 'CollectionPage',
                'name' => $title,
                'description' => $desc,
                'url' => $url,
            ];
        }
        return [
            'title'=>$title,
            'description'=>$desc,
            'og'=>['title'=>$title,'description'=>$desc,'url'=>$url],
            'canonical'=>$url,
            'json_ld'=>$jsonLd,
        ];
    }

    public static function listCategoriesMeta(): array
    {
        $title = Config::get('seo.lists.categories.title', 'Crypto Categories — Market Caps & Performance — BlocFolio');
        $desc = Config::get('seo.lists.categories.description', 'Browse crypto categories with market caps, volumes, and performance.');
        $url = rtrim(Config::get('app.base_url',''),'/') . '/categories';
        $jsonLd = null;
        if (Config::get('seo.lists.categories.jsonld', true)) {
            $jsonLd = [
                '@context' => 'https://schema.org',
                '@type' => 'CollectionPage',
                'name' => $title,
                'description' => $desc,
                'url' => $url,
            ];
        }
        return [
            'title'=>$title,
            'description'=>$desc,
            'og'=>['title'=>$title,'description'=>$desc,'url'=>$url],
            'canonical'=>$url,
            'json_ld'=>$jsonLd,
        ];
    }

    public static function listExchangesMeta(): array
    {
        $title = Config::get('seo.lists.exchanges.title', 'Crypto Exchanges — Volume & Markets — BlocFolio');
        $desc = Config::get('seo.lists.exchanges.description', 'Compare exchanges by trust score, 24h volume, and markets.');
        $url = rtrim(Config::get('app.base_url',''),'/') . '/exchanges';
        $jsonLd = null;
        if (Config::get('seo.lists.exchanges.jsonld', true)) {
            $jsonLd = [
                '@context' => 'https://schema.org',
                '@type' => 'CollectionPage',
                'name' => $title,
                'description' => $desc,
                'url' => $url,
            ];
        }
        return [
            'title'=>$title,
            'description'=>$desc,
            'og'=>['title'=>$title,'description'=>$desc,'url'=>$url],
            'canonical'=>$url,
            'json_ld'=>$jsonLd,
        ];
    }
}
