<?php
namespace App;

class Snapshot
{
    public static function write(string $route, string $html, int $ttlSec = 86400): void
    {
        $path = self::pathFor($route);
        $etag = sha1($html);
        $payload = "<!-- etag:$etag expires:" . (time()+$ttlSec) . " -->\n" . $html;
        file_put_contents($path, $payload);
    }

    public static function invalidate(string $route): void
    {
        $path = self::pathFor($route);
        if (is_file($path)) @unlink($path);
    }

    public static function pathFor(string $route): string
    {
        $safe = trim($route, '/');
        if ($safe === '') $safe = 'home';
        $safe = preg_replace('/[^a-zA-Z0-9_\-\/]/', '_', $safe);
        $safe = str_replace('/', '__', $safe);
        $dir = __DIR__ . '/../storage/html_snapshots';
        if (!is_dir($dir)) @mkdir($dir, 0777, true);
        return $dir . '/' . $safe . '.html';
    }
}
