<div class="container" style="max-width:760px">
  <h1 class="h3 mb-3">Admin Settings</h1>
  <form method="post" action="/admin/settings?token=<?= htmlspecialchars($token) ?>">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">App</div>
      <div class="mb-3">
        <label class="form-label">Base URL</label>
        <input class="form-control" name="app_base_url" placeholder="https://example.com" value="<?= htmlspecialchars(($settings['app.base_url'] ?? App\Config::get('app.base_url')) ?: '') ?>">
      </div>
      <div class="mb-3">
        <label class="form-label">Default Currency</label>
        <input class="form-control" name="currency_default" value="<?= htmlspecialchars(($settings['app.currency_default'] ?? App\Config::get('app.currency_default') ) ?: 'USD') ?>">
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">CoinGecko</div>
      <div class="mb-3">
        <label class="form-label">Rate Limit per Minute</label>
        <input class="form-control" type="number" min="1" max="60" name="cg_rate" value="<?= htmlspecialchars(($settings['coingecko.rate_limit_per_min'] ?? App\Config::get('coingecko.rate_limit_per_min')) ?: 30) ?>">
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">SEO Templates — Coin Page</div>
      <div class="mb-3">
        <label class="form-label">Title</label>
        <input class="form-control" name="seo_coin_title" placeholder="{name} ({symbol}) Price, Chart, Market Cap & Stats — BlocFolio" value="<?= htmlspecialchars(($settings['seo.coin.title'] ?? App\Config::get('seo.coin.title')) ?: '') ?>">
        <div class="small text-muted">Placeholders: {name} {symbol} {currency} {price}</div>
      </div>
      <div class="mb-3">
        <label class="form-label">Description</label>
        <textarea class="form-control" rows="3" name="seo_coin_desc" placeholder="Live {name} price in {currency}, market cap, ..."><?= htmlspecialchars(($settings['seo.coin.description'] ?? App\Config::get('seo.coin.description')) ?: '') ?></textarea>
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">Analytics</div>
      <div class="mb-3">
        <label class="form-label">GA4 Measurement ID</label>
        <input class="form-control" name="seo_ga4_id" placeholder="G-XXXXXXXXXX" value="<?= htmlspecialchars(($settings['seo.ga4_id'] ?? App\Config::get('seo.ga4_id')) ?: '') ?>">
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">reCAPTCHA</div>
      <div class="form-check form-switch mb-2">
        <input class="form-check-input" type="checkbox" name="recaptcha_enabled" value="1" <?= ((App\Config::get('recaptcha.enabled', false)) ? 'checked' : '') ?>>
        <label class="form-check-label">Enable reCAPTCHA on login/register</label>
      </div>
      <div class="mb-2"><label class="form-label">Site Key</label><input class="form-control" name="recaptcha_site_key" value="<?= htmlspecialchars(App\Config::get('recaptcha.site_key','')) ?>"></div>
      <div class="mb-2"><label class="form-label">Secret</label><input class="form-control" name="recaptcha_secret" value="<?= htmlspecialchars(App\Config::get('recaptcha.secret','')) ?>"></div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">List Pages SEO</div>
      <div class="mb-2 text-muted small">Coins</div>
      <div class="mb-2"><input class="form-control" name="seo_lists_coins_title" placeholder="Top Crypto Coins by Market Cap — BlocFolio" value="<?= htmlspecialchars(($settings['seo.lists.coins.title'] ?? App\Config::get('seo.lists.coins.title')) ?: '') ?>"></div>
      <div class="mb-3"><textarea class="form-control" rows="2" name="seo_lists_coins_desc" placeholder="Live market caps, prices, and 24h change for top cryptocurrencies."><?= htmlspecialchars(($settings['seo.lists.coins.description'] ?? App\Config::get('seo.lists.coins.description')) ?: '') ?></textarea></div>
      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" name="seo_lists_coins_jsonld" value="1" <?= (($settings['seo.lists.coins.jsonld'] ?? App\Config::get('seo.lists.coins.jsonld')) ? 'checked' : '') ?>>
        <label class="form-check-label">Enable JSON-LD</label>
      </div>
      <div class="mb-2 text-muted small">Categories</div>
      <div class="mb-2"><input class="form-control" name="seo_lists_categories_title" placeholder="Crypto Categories — Market Caps & Performance — BlocFolio" value="<?= htmlspecialchars(($settings['seo.lists.categories.title'] ?? App\Config::get('seo.lists.categories.title')) ?: '') ?>"></div>
      <div class="mb-3"><textarea class="form-control" rows="2" name="seo_lists_categories_desc" placeholder="Browse crypto categories with market caps, volumes, and performance."><?= htmlspecialchars(($settings['seo.lists.categories.description'] ?? App\Config::get('seo.lists.categories.description')) ?: '') ?></textarea></div>
      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" name="seo_lists_categories_jsonld" value="1" <?= (($settings['seo.lists.categories.jsonld'] ?? App\Config::get('seo.lists.categories.jsonld')) ? 'checked' : '') ?>>
        <label class="form-check-label">Enable JSON-LD</label>
      </div>
      <div class="mb-2 text-muted small">Exchanges</div>
      <div class="mb-2"><input class="form-control" name="seo_lists_exchanges_title" placeholder="Crypto Exchanges — Volume & Markets — BlocFolio" value="<?= htmlspecialchars(($settings['seo.lists.exchanges.title'] ?? App\Config::get('seo.lists.exchanges.title')) ?: '') ?>"></div>
      <div class="mb-3"><textarea class="form-control" rows="2" name="seo_lists_exchanges_desc" placeholder="Compare exchanges by trust score, 24h volume, and markets."><?= htmlspecialchars(($settings['seo.lists.exchanges.description'] ?? App\Config::get('seo.lists.exchanges.description')) ?: '') ?></textarea></div>
      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" name="seo_lists_exchanges_jsonld" value="1" <?= (($settings['seo.lists.exchanges.jsonld'] ?? App\Config::get('seo.lists.exchanges.jsonld')) ? 'checked' : '') ?>>
        <label class="form-check-label">Enable JSON-LD</label>
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">Snapshots</div>
      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" name="seo_snapshots_enable_lists" value="1" <?= ((App\Config::get('seo.snapshots.enable_lists', true)) ? 'checked' : '') ?>>
        <label class="form-check-label">Enable list page snapshots</label>
      </div>
      <div class="row g-2">
        <div class="col-4"><label class="form-label">Coins TTL (sec)</label><input class="form-control" type="number" name="seo_snapshots_ttl_coins" value="<?= htmlspecialchars((string)(App\Config::get('seo.snapshots.ttl.coins', 10800))) ?>"></div>
        <div class="col-4"><label class="form-label">Categories TTL</label><input class="form-control" type="number" name="seo_snapshots_ttl_categories" value="<?= htmlspecialchars((string)(App\Config::get('seo.snapshots.ttl.categories', 21600))) ?>"></div>
        <div class="col-4"><label class="form-label">Exchanges TTL</label><input class="form-control" type="number" name="seo_snapshots_ttl_exchanges" value="<?= htmlspecialchars((string)(App\Config::get('seo.snapshots.ttl.exchanges', 21600))) ?>"></div>
      </div>
    </div>

    <div class="card p-3 mb-3">
      <div class="mb-2 fw-semibold">Mail</div>
      <div class="mb-2"><label class="form-label">From</label><input class="form-control" name="mail_from" value="<?= htmlspecialchars(App\Config::get('mail.from','')) ?>"></div>
      <div class="mb-2"><label class="form-label">Transport</label>
        <select class="form-select" name="mail_transport">
          <?php $mt=App\Config::get('mail.transport','mail'); ?>
          <option value="mail" <?= $mt==='mail'?'selected':'' ?>>PHP mail()</option>
          <option value="smtp" <?= $mt==='smtp'?'selected':'' ?>>SMTP</option>
        </select>
      </div>
      <div class="row g-2">
        <div class="col-6"><label class="form-label">SMTP Host</label><input class="form-control" name="mail_smtp_host" value="<?= htmlspecialchars(App\Config::get('mail.smtp.host','')) ?>"></div>
        <div class="col-2"><label class="form-label">Port</label><input class="form-control" name="mail_smtp_port" value="<?= htmlspecialchars(App\Config::get('mail.smtp.port','587')) ?>"></div>
        <div class="col-4"><label class="form-label">Secure</label>
          <select class="form-select" name="mail_smtp_secure">
            <?php $sec=App\Config::get('mail.smtp.secure','starttls'); ?>
            <option value="starttls" <?= $sec==='starttls'?'selected':'' ?>>STARTTLS</option>
            <option value="ssl" <?= $sec==='ssl'?'selected':'' ?>>SSL</option>
            <option value="none" <?= $sec==='none'?'selected':'' ?>>None</option>
          </select>
        </div>
      </div>
      <div class="row g-2 mt-2">
        <div class="col-6"><label class="form-label">SMTP User</label><input class="form-control" name="mail_smtp_user" value="<?= htmlspecialchars(App\Config::get('mail.smtp.user','')) ?>"></div>
        <div class="col-6"><label class="form-label">SMTP Pass</label><input class="form-control" name="mail_smtp_pass" value="<?= htmlspecialchars(App\Config::get('mail.smtp.pass','')) ?>"></div>
      </div>
    </div>

    <button class="btn btn-light">Save Settings</button>
  </form>
</div>
