<div class="row">
  <div class="col-12 col-lg-5">
    <div class="card p-3 mb-3">
      <div class="fw-semibold mb-2">Create Alert</div>
      <form method="post" action="/alerts/create" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="col-12">
          <label class="form-label">Coin slug</label>
          <input name="slug" class="form-control" placeholder="bitcoin" required>
        </div>
        <div class="col-4">
          <label class="form-label">Type</label>
          <select name="type" class="form-select">
            <option value="price">Price</option>
            <option value="pct">% Change (24h)</option>
          </select>
        </div>
        <div class="col-3">
          <label class="form-label">Op</label>
          <select name="op" class="form-select">
            <option value="above">Above</option>
            <option value="below">Below</option>
          </select>
        </div>
        <div class="col-5">
          <label class="form-label">Value</label>
          <input name="value" class="form-control" type="number" step="0.0001" required>
        </div>
        <div class="col-12">
          <button class="btn btn-light">Add Alert</button>
        </div>
      </form>
    </div>
  </div>
  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="fw-semibold mb-2">My Alerts</div>
      <table class="table table-dark table-sm align-middle">
        <thead><tr><th>Coin</th><th>Type</th><th>Condition</th><th>Last Trigger</th><th></th></tr></thead>
        <tbody>
          <?php foreach ($alerts as $a): ?>
            <tr>
              <td><?= htmlspecialchars(($a['symbol']??'')? strtoupper($a['symbol']).' — ':'') ?><a class="text-decoration-none" href="/coins/<?= htmlspecialchars($a['slug']) ?>"><?= htmlspecialchars($a['name']??$a['slug']) ?></a></td>
              <td><?= htmlspecialchars($a['type']) ?></td>
              <td class="small text-muted"><?= htmlspecialchars($a['condition_json']) ?></td>
              <td class="small text-muted"><?= htmlspecialchars($a['last_triggered_at'] ?? '—') ?></td>
              <td>
                <form method="post" action="/alerts/delete">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)$a['id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

