<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0">Categories</h1>
</div>
<div class="card p-2">
  <div class="table-responsive">
    <table id="categories-table" class="table table-dark table-hover align-middle mb-0" style="width:100%">
      <thead>
      <tr>
        <th>Name</th>
        <th class="text-end">Market Cap</th>
        <th class="text-end">24h Volume</th>
        <th class="text-end">Coins</th>
      </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>
<script>
  const table = new DataTable('#categories-table', {
    serverSide:true, processing:true,
    ajax:'/api/categories', order:[[1,'desc']], pageLength:25,
    columns:[
      {data:null, render:r=>`<a class="text-decoration-none" href="/categories/${r.slug}"><strong>${r.name}</strong></a>`},
      {data:'market_cap', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString()):'—'},
      {data:'volume_24h', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString()):'—'},
      {data:'num_coins', className:'text-end'}
    ]
  });
</script>

