<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0">Exchanges</h1>
</div>
<div class="card p-2">
  <div class="table-responsive">
    <table id="exchanges-table" class="table table-dark table-hover align-middle mb-0" style="width:100%">
      <thead>
      <tr>
        <th>Name</th>
        <th>Country</th>
        <th>Trust</th>
        <th class="text-end">24h Volume</th>
      </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>
<script>
  const table = new DataTable('#exchanges-table', {
    serverSide:true, processing:true,
    ajax:'/api/exchanges',
    order:[[2,'desc']], pageLength:25,
    columns:[
      {data:null, render: r=>`<a class="text-decoration-none" href="/exchanges/${r.slug}">${r.logo?`<img class='logo me-2' src='${r.logo}'>`:''}<strong>${r.name}</strong></a>`},
      {data:'country'},
      {data:'trust_score'},
      {data:'volume_24h', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString()):'—'}
    ]
  });
</script>

