<?php $ex = $exchange; ?>
<div class="d-flex align-items-center mb-3">
  <?php if (!empty($ex['logo'])): ?><img class="logo me-2" src="<?= htmlspecialchars($ex['logo']) ?>" alt=""><?php endif; ?>
  <h1 class="h3 m-0"><?= htmlspecialchars($ex['name']) ?></h1>
  <?php if (!empty($ex['trust_score'])): ?><span class="ms-3 badge badge-gold">Trust <?= (int)$ex['trust_score'] ?></span><?php endif; ?>
  <div class="ms-auto text-muted small">Country: <?= htmlspecialchars($ex['country'] ?? '—') ?></div>
</div>

<div class="card p-2">
  <div class="table-responsive">
    <table id="markets-table" class="table table-dark table-hover align-middle mb-0" style="width:100%">
      <thead>
      <tr>
        <th>Pair</th>
        <th class="text-end">Last</th>
        <th class="text-end">24h Volume</th>
        <th>Type</th>
      </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
  const table = new DataTable('#markets-table', {
    serverSide:true, processing:true,
    ajax:'/api/exchanges/<?= htmlspecialchars($ex['slug']) ?>/markets',
    order:[[2,'desc']], pageLength:25,
    columns:[
      {data:'pair'},
      {data:'last_price', className:'text-end', render:d=> d!=null?Number(d).toLocaleString(undefined,{maximumFractionDigits:8}):'—'},
      {data:'volume_24h', className:'text-end', render:d=> d!=null?Number(d).toLocaleString(): '—'},
      {data:'is_spot', render:d=> d? 'Spot' : 'Derivatives'}
    ]
  });
</script>

