<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0">Screens</h1>
  <div class="ms-auto">
    <a class="btn btn-sm btn-light" href="/screens/new">New Screen</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Your Screens</div>
      <?php if (!empty($mine)): ?>
        <ul class="list-unstyled m-0">
          <?php foreach ($mine as $s): ?>
            <li class="py-1"><a class="text-decoration-none" href="/screens/<?= htmlspecialchars($s['slug']) ?>"><?= htmlspecialchars($s['name']) ?></a> <span class="badge bg-secondary ms-2"><?= htmlspecialchars($s['visibility']) ?></span></li>
          <?php endforeach; ?>
        </ul>
      <?php else: ?>
        <div class="text-muted small">No screens yet.</div>
      <?php endif; ?>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="d-flex align-items-center mb-2"><div class="fw-semibold">Public Screens</div><div class="ms-auto small"><a class="text-decoration-none" href="/screens?sort=stars">Sort by Stars</a></div></div>
      <?php if (!empty($public)): ?>
        <ul class="list-unstyled m-0">
          <?php foreach ($public as $s): ?>
            <li class="py-1 d-flex align-items-center justify-content-between">
              <a class="text-decoration-none" href="/screens/<?= htmlspecialchars($s['slug']) ?>"><?= htmlspecialchars($s['name']) ?></a>
              <?php if (isset($s['stars'])): ?><span class="badge bg-secondary"><i class="fa fa-star me-1"></i><?= (int)$s['stars'] ?></span><?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
      <?php else: ?>
        <div class="text-muted small">No public screens yet.</div>
      <?php endif; ?>
    </div>
  </div>
</div>
