<div class="row">
  <div class="col-12 col-lg-5">
    <div class="card p-3 mb-3">
      <div class="fw-semibold mb-2">New Screen</div>
      <form method="post" action="/screens/new">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="mb-3">
          <label class="form-label">Name</label>
          <input class="form-control" name="name" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Visibility</label>
          <select class="form-select" name="visibility">
            <option value="private">Private</option>
            <option value="public">Public</option>
            <option value="unlisted">Unlisted</option>
          </select>
        </div>
        <div class="mb-3">
          <label class="form-label">DSL Query</label>
          <textarea class="form-control" rows="6" name="dsl" id="dsl" placeholder="<?= htmlspecialchars($sample) ?>" required><?= htmlspecialchars($sample) ?></textarea>
        </div>
        <button class="btn btn-light">Save Screen</button>
      </form>
    </div>
  </div>
  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="d-flex align-items-center mb-2"><div class="fw-semibold">Live Preview</div><div class="small text-muted ms-2">(top 100)</div></div>
      <div class="table-responsive">
        <table class="table table-dark table-sm align-middle mb-0" id="preview">
          <thead><tr><th>Rank</th><th>Coin</th><th class="text-end">Price</th><th class="text-end">24h %</th><th class="text-end">MCap</th><th class="text-end">Vol 24h</th></tr></thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
  async function refreshPreview(){
    const dsl = document.getElementById('dsl').value;
    try{
      const res = await fetch('/api/screens/preview?dsl='+encodeURIComponent(dsl));
      const json = await res.json();
      const tbody = document.querySelector('#preview tbody');
      tbody.innerHTML = '';
      (json.data||[]).forEach(r=>{
        const tr = document.createElement('tr');
        tr.innerHTML = `<td>${r.rank||''}</td>
                        <td><a class="text-decoration-none" href="/coins/${r.slug}"><strong>${r.name}</strong> <span class="text-muted">(${(r.symbol||'').toUpperCase()})</span></a></td>
                        <td class="text-end">${r.price!=null?('$'+Number(r.price).toLocaleString(undefined,{maximumFractionDigits:6})):'—'}</td>
                        <td class="text-end ${r.change_24h>=0?'up':'down'}">${r.change_24h!=null?Number(r.change_24h).toFixed(2)+'%':'—'}</td>
                        <td class="text-end">${r.market_cap!=null?('$'+Number(r.market_cap).toLocaleString()):'—'}</td>
                        <td class="text-end">${r.volume_24h!=null?('$'+Number(r.volume_24h).toLocaleString()):'—'}</td>`;
        tbody.appendChild(tr);
      });
    }catch(e){}
  }
  document.getElementById('dsl').addEventListener('input', ()=>{ clearTimeout(window.__dslTimer); window.__dslTimer=setTimeout(refreshPreview, 400); });
  refreshPreview();
</script>

