<div class="d-flex align-items-center mb-3">
  <h1 class="h4 m-0"><?= htmlspecialchars($screen['name']) ?></h1>
  <span class="ms-3 badge bg-secondary text-uppercase small"><?= htmlspecialchars($screen['visibility']) ?></span>
  <button class="btn btn-sm btn-outline-light ms-3" id="starBtn"><i class="fa fa-star"></i> Star</button>
  <form method="post" action="/screens/new" class="ms-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(App\Auth::csrfToken()) ?>">
    <input type="hidden" name="name" value="Fork of <?= htmlspecialchars($screen['name']) ?>">
    <input type="hidden" name="visibility" value="private">
    <input type="hidden" name="dsl" value="<?= htmlspecialchars(json_decode($screen['definition_json'],true)['dsl'] ?? '') ?>">
    <button class="btn btn-sm btn-outline-light">Fork</button>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-dark table-sm align-middle mb-0">
      <thead><tr><th>Rank</th><th>Coin</th><th class="text-end">Price</th><th class="text-end">24h %</th><th class="text-end">MCap</th><th class="text-end">Vol 24h</th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= (int)($r['rank'] ?? 0) ?></td>
          <td><a class="text-decoration-none" href="/coins/<?= htmlspecialchars($r['slug']) ?>"><strong><?= htmlspecialchars($r['name']) ?></strong> <span class="text-muted">(<?= htmlspecialchars(strtoupper($r['symbol']??'')) ?>)</span></a></td>
          <td class="text-end"><?= $r['price']!==null?('$'.number_format((float)$r['price'],6)):'—' ?></td>
          <?php $p = $r['change_24h']; $cls = $p>=0?'up':'down'; ?>
          <td class="text-end <?= $cls ?>"><?= $p!==null?number_format((float)$p,2).'%':'—' ?></td>
          <td class="text-end"><?= $r['market_cap']!==null?('$'.number_format((float)$r['market_cap'])):'—' ?></td>
          <td class="text-end"><?= $r['volume_24h']!==null?('$'.number_format((float)$r['volume_24h'])):'—' ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
  (function(){
    const btn=document.getElementById('starBtn');
    if(!btn) return;
    btn.addEventListener('click', async function(){
      const res = await fetch('/api/screens/<?= htmlspecialchars($screen['slug']) ?>/star', {method:'POST', body: (new FormData()).append('csrf', window.CSRF)});
      if (res.status===401){ alert('Please login to star'); return; }
      const j = await res.json();
      const on = !!j.starred; btn.classList.toggle('btn-warning', on);
    });
  })();
</script>
