<div class="d-flex align-items-center mb-3">
  <h1 class="h4 m-0">My Watchlists</h1>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Create Watchlist</div>
      <form method="post" action="/watchlists/new" class="row g-2">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="col-8"><input class="form-control" name="name" placeholder="Name" required></div>
        <div class="col-4">
          <select class="form-select" name="visibility">
            <option value="private">Private</option>
            <option value="unlisted">Unlisted</option>
            <option value="public">Public</option>
          </select>
        </div>
        <div class="col-12"><button class="btn btn-light">Create</button></div>
      </form>
    </div>
  </div>
  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Your Watchlists</div>
      <ul class="list-unstyled m-0">
        <?php foreach ($lists as $w): ?>
          <li class="py-1">
            <strong><?= htmlspecialchars($w['name']) ?></strong>
            <span class="badge bg-secondary text-uppercase ms-2 small"><?= htmlspecialchars($w['visibility']) ?></span>
            <?php if ($w['is_default']): ?><span class="badge bg-warning text-dark ms-1">Default</span><?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  </div>
</div>

