<?php
// Load config (local overrides default)
$config = require __DIR__ . '/config.php';
if (file_exists(__DIR__ . '/config.local.php')) {
    $config = array_replace_recursive($config, require __DIR__ . '/config.local.php');
}

// Minimal autoloader for app classes
spl_autoload_register(function ($class) {
    $base = __DIR__ . '/';
    $class = str_replace('..', '', $class);
    $paths = [
        $base . $class . '.php',
        $base . str_replace('\\', '/', $class) . '.php',
    ];
    foreach ($paths as $p) {
        if (file_exists($p)) {
            require_once $p;
            return;
        }
    }
});

// Configure App
App\Config::set($config);

// Optionally overlay DB settings (admin_settings) after DB is available
try {
    $pdo = App\Database::pdo();
    $stmt = $pdo->query('SELECT `key`, `value_json` FROM admin_settings');
    $rows = $stmt ? $stmt->fetchAll() : [];
    if ($rows) {
        foreach ($rows as $r) {
            $key = $r['key'];
            $val = json_decode($r['value_json'], true);
            if ($val === null) continue;
            // set nested config via dot key
            $segments = explode('.', $key);
            $ref =& $config;
            foreach ($segments as $seg) {
                if (!isset($ref[$seg]) || !is_array($ref[$seg])) { $ref[$seg] = []; }
                $ref =& $ref[$seg];
            }
            $ref = $val;
        }
        App\Config::set($config);
    }
} catch (\Throwable $e) {
    // ignore overlay errors during early boot (e.g., before DB exists)
}
