<?php
return [
    'app' => [
        'env' => getenv('APP_ENV') ?: 'dev',
        'name' => 'BlocFolio',
        'base_url' => getenv('APP_URL') ?: '',
        'timezone' => 'UTC',
        'currency_default' => 'USD',
        'admin_token' => getenv('ADMIN_TOKEN') ?: '',
    ],
    'db' => [
        'host' => getenv('DB_HOST') ?: '127.0.0.1',
        'port' => (int)(getenv('DB_PORT') ?: 3306),
        'name' => getenv('DB_NAME') ?: 'blocfolio',
        'user' => getenv('DB_USER') ?: 'root',
        'pass' => getenv('DB_PASS') ?: '',
        'charset' => 'utf8mb4',
    ],
    'assets' => [
        'bootstrap_css' => 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css',
        'bootstrap_js' => 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js',
        'fonts' => 'https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Space+Grotesk:wght@500;600;700&display=swap',
        'fontawesome' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css',
        'material_icons' => 'https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined',
        'echarts' => 'https://cdnjs.cloudflare.com/ajax/libs/echarts/5.5.0/echarts.min.js',
        'datatables_css' => 'https://cdn.datatables.net/v/bs5/dt-2.0.5/datatables.min.css',
        'datatables_js' => 'https://cdn.datatables.net/v/bs5/dt-2.0.5/datatables.min.js',
    ],
    'coingecko' => [
        'base' => 'https://api.coingecko.com/api/v3',
        'rate_limit_per_min' => 30,
        'timeout_sec' => 20,
        'vs_currencies' => ['usd'],
    ],
];
