<?php
// Evaluate active alerts and create notifications when triggered
require __DIR__ . '/../../app/bootstrap.php';

use App\Database;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$pdo = Database::pdo();

// Load active alerts with coin latest snapshot
$alerts = $pdo->query("SELECT a.*, c.slug, c.name, c.symbol,
  (SELECT price FROM coin_market_snapshots ms WHERE ms.coin_id = c.id AND ms.currency = 'usd' ORDER BY timestamp DESC LIMIT 1) AS cur_price,
  (SELECT change_24h FROM coin_market_snapshots ms WHERE ms.coin_id = c.id AND ms.currency = 'usd' ORDER BY timestamp DESC LIMIT 1) AS cur_pct
  FROM alerts a JOIN coins c ON c.id = a.coin_id WHERE a.is_active = 1")->fetchAll();

$insNotif = $pdo->prepare('INSERT INTO notifications (user_id, title, body, channel, status) VALUES (:u,:t,:b,\'email\',\'queued\')');
$updAlert = $pdo->prepare('UPDATE alerts SET last_triggered_at = NOW() WHERE id = :id');

$n = 0;
foreach ($alerts as $a) {
    $cond = json_decode($a['condition_json'] ?? '{}', true) ?: [];
    $type = $a['type'];
    $ok = false;
    if ($type === 'price') {
        $op = $cond['op'] ?? 'above';
        $price = (float)($cond['price'] ?? 0);
        $cur = (float)($a['cur_price'] ?? 0);
        if ($price > 0 && $cur > 0) {
            $ok = ($op === 'above') ? ($cur >= $price) : ($cur <= $price);
        }
    } elseif ($type === 'pct') {
        $op = $cond['op'] ?? 'above';
        $pct = (float)($cond['pct'] ?? 0);
        $cur = (float)($a['cur_pct'] ?? 0);
        $ok = ($op === 'above') ? ($cur >= $pct) : ($cur <= $pct);
    }
    if ($ok) {
        $title = 'Alert: ' . strtoupper($a['symbol']) . ' ' . $type . ' triggered';
        $body = json_encode(['slug'=>$a['slug'], 'type'=>$type, 'current_price'=>$a['cur_price'], 'current_pct'=>$a['cur_pct'], 'cond'=>$cond]);
        $insNotif->execute([':u'=>(int)$a['user_id'], ':t'=>$title, ':b'=>$body]);
        $updAlert->execute([':id'=>(int)$a['id']]);
        $n++;
    }
}

echo "alerts_dispatch processed, triggered: {$n}\n";

