<?php
namespace Scripts\Lib;

class HttpException extends \RuntimeException
{
    private int $status;
    private ?int $retryAfter;
    public function __construct(string $message, int $status = 0, ?int $retryAfter = null)
    { parent::__construct($message, $status); $this->status = $status; $this->retryAfter = $retryAfter; }
    public function getStatus(): int { return $this->status; }
    public function getRetryAfter(): ?int { return $this->retryAfter; }
}

class Http
{
    public static function getJson(string $url, int $timeout = 20): array
    {
        $headers = [];
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_TIMEOUT => $timeout,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_USERAGENT => 'BlocFolio/1.0 (+https://blocfolio.example)'
        ]);
        curl_setopt($ch, CURLOPT_HEADERFUNCTION, function($ch, $header) use (&$headers) {
            $len = strlen($header);
            $parts = explode(':', $header, 2);
            if (count($parts) == 2) {
                $headers[strtolower(trim($parts[0]))] = trim($parts[1]);
            }
            return $len;
        });
        $body = curl_exec($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err = curl_error($ch);
        curl_close($ch);
        if ($body === false) {
            throw new HttpException('HTTP error: ' . $err, 0, null);
        }
        if ($status >= 400) {
            $retryAfter = null;
            if ($status == 429 && isset($headers['retry-after'])) {
                $retryAfter = (int)$headers['retry-after'];
            }
            throw new HttpException('HTTP status ' . $status . ' for ' . $url, $status, $retryAfter);
        }
        $data = json_decode($body, true);
        if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
            throw new HttpException('Invalid JSON response: ' . json_last_error_msg(), $status, null);
        }
        return $data ?? [];
    }
}

