<?php
namespace Scripts\Lib;

class Lock
{
    private $handle;
    private string $path;
    public function __construct(string $name)
    {
        $dir = __DIR__ . '/../../storage/locks';
        if (!is_dir($dir)) @mkdir($dir, 0777, true);
        $this->path = $dir . '/' . preg_replace('/[^a-zA-Z0-9_\-]/','_', $name) . '.lock';
    }
    public function acquire(): bool
    {
        $this->handle = fopen($this->path, 'c');
        if (!$this->handle) return false;
        if (!flock($this->handle, LOCK_EX | LOCK_NB)) {
            fclose($this->handle);
            $this->handle = null;
            return false;
        }
        fwrite($this->handle, (string)getmypid());
        fflush($this->handle);
        return true;
    }
    public function release(): void
    {
        if ($this->handle) {
            flock($this->handle, LOCK_UN);
            fclose($this->handle);
            $this->handle = null;
            @unlink($this->path);
        }
    }
    public function __destruct() { $this->release(); }
}

