<?php
// Purge all HTML snapshots or a specific route
require __DIR__ . '/../../app/bootstrap.php';

use App\Snapshot;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$route = $argv[1] ?? null;
if ($route) {
    Snapshot::invalidate($route);
    echo "Purged snapshot for {$route}\n";
    exit;
}

$dir = __DIR__ . '/../../storage/html_snapshots';
$count = 0;
if (is_dir($dir)) {
    foreach (glob($dir . '/*.html') as $file) {
        @unlink($file);
        $count++;
    }
}
echo "Purged {$count} snapshots.\n";

